/* 
   CC0 2011, Martin Haye

   To the extent possible under law, Martin Haye has waived all copyright 
   and related or neighboring rights to p2e: Pseudo-II Emulator. 
   This work is published from: United States.
*/

var animateX = -20;
var animateInterval = 24;

var currentPage = null;
var currentDialog = null;
var currentWidth = 0;
var currentHash = location.hash;
var hashPrefix = "#_";
var pageHistory = [];

function $(idOrEl) 
{
  if (idOrEl == null)
    return null;
  if (typeof(idOrEl) == "string")
    return document.getElementById(idOrEl);
  return idOrEl;
}

addEventListener("load", function(event)
{
    var body = document.getElementsByTagName("body")[0];
    for (var child = body.firstChild; child; child = child.nextSibling)
    {
        if (child.nodeType == 1 && child.getAttribute("selected") == "true")
        {
            showPage(child);
            break;
        }
    }

    setInterval(checkOrientAndLocation, 300);
    setTimeout(hideAddress, 100);
}, false);

function hideAddress() {

    window.scrollTo(0, 1); // pan to the bottom, hides the location bar
}

addEventListener("click", function(event)
{
    var link = event.target;
    while (link && link.localName && link.localName.toLowerCase() != "a")
        link = link.parentNode;

    if (link && link.hash)
    {
        var page = $(link.hash.substr(1));
        showPage(page);
        event.preventDefault();
    }
}, true);

function checkOrientAndLocation()
{
    if (window.innerWidth != currentWidth)
    {
        currentWidth = window.innerWidth;

        var orient = innerWidth == 320 ? "portrait" : "landscape";
        //document.body.setAttribute("orient", orient);
        setTimeout(hideAddress, 100);
    }
    
    updateKeyboardPosition();

/*
    if (location.hash != currentHash)
    {
        currentHash = location.hash;

        var pageId = currentHash.substr(hashPrefix.length);
        switchToPage(pageId);
    }
*/
}

// global function    
function showPage(page)
{
    page = $(page); // in case id passed instead of element
      
    if (page == null)
      return;
    var pageId = page.id;
    
    var index = pageHistory.indexOf(pageId);
    var backwards = index != -1;
    if (backwards) {
        pageHistory.splice(index, pageHistory.length);
    }
    
    if (currentDialog)
    {
        currentDialog.removeAttribute("selected");
        currentDialog = null;
    }

    if (page.className.indexOf("dialog") != -1)
    {
        showDialog(page);
    }
    else
    {        
        if (page.id != "Main" || location.hash != "")
            location.href = currentHash = hashPrefix + page.id;
        pageHistory.push(page.id);

        var fromPage = currentPage;
        currentPage = page;

        var pageTitle = $("pageTitle");
        pageTitle.innerHTML = page.title || "";

        var homeButton = $("homeButton");
        if (homeButton)
        {
            homeButton.style.display = (page.id) == "Main" ? "none" : "inline";
            var parentName = page.getAttribute("parentName");
            if(parentName != undefined)
            {
                homeButton.innerHTML = parentName || "";
                homeButton.href="#"+parentName;
            }
        }
        if(fromPage) 
        {
            setTimeout(swipePage, 0, fromPage, page, backwards);
         }
    }
}

function swipePage(fromPage, toPage, backwards)
{   
    if (fromPage.id == "Main")
      onLeaveMain();
    
    toPage.style.left = "100%";
    toPage.setAttribute("selected", "true");
    scrollTo(0, 1);

    var percent = 100;
    var timer = setInterval(function()
    {
        percent += animateX;
        if (percent <= 0)
        {
            percent = 0;
            fromPage.removeAttribute("selected");
            clearInterval(timer);
            if (toPage.id == "Main")
                onReturnToMain();
        }

        fromPage.style.left = (backwards ? (100-percent) : (percent-100)) + "%"; 
        toPage.style.left = (backwards ? -percent : percent) + "%"; 
    }, animateInterval);
}

function showDialog(form)
{
    currentDialog = form;
    form.setAttribute("selected", "true");
    
    form.onsubmit = function(event)
    {
        event.preventDefault();
        form.removeAttribute("selected");

        var index = form.action.lastIndexOf("#");
        if (index != -1)
            showPage($(form.action.substr(index+1)));
    }

    form.onclick = function(event)
    {
        if (event.target == form)
            form.removeAttribute("selected");
    }
}
